function P82_vi
% Problem 8.2 :	The growth/decay of population of animal species
% vi. sensitive dependence on initial conditions

% Set two r's given in problem
r=[3.57 3.7];
% Set initial population
x0=0.5;
% set small difference of initial population
dx0=0.00001;
for i=1:length(r)
    % calcuate population with x0-dx0
    xn1=LogiEqn(r(i),x0-dx0);
    % calcuate population with x0-dx0
    xn2=LogiEqn(r(i),x0+dx0);
    % plot and compare the results with above initial populations
    figure(i);
    plot(0:length(xn1),[x0;xn1],'r*',0:length(xn2),[x0;xn2],'bo');
    d=axis(); d(3:4)=[0 1]; axis(d); grid on;
    set(gca,'FontSize',24);
    xlabel('\bfThe population at year (a.u.)');
    ylabel('\bfThe normalized population x_n (a.u.)');
    title(['\bfThe Normalized Population for r=' num2str(r(i)) '& x_0=' num2str(x0)]);
    legend('\bfx_0-\Deltax_0','\bfx_0+\Deltax_0','Location','SouthEast');
end
end

function xn=LogiEqn(r,x0)
%
% Calculate quadratic reccureance relations
% x_n+1=r*x_n
%
nf=500;
xn=zeros(nf,1);
x=x0;
for i=1:nf
    xn(i)=r*x.*(1-x);
    x=xn(i);
end
end    